
/****** Object:  StoredProcedure [dbo].[P_GERA_RESSUPRIMENTO_FORNECEDOR_FILIAL]    Script Date: 07/11/2013 14:02:45 ******/
IF  EXISTS (SELECT * FROM sys.objects 
				WHERE 
					object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_CPL_MOVIMENTACAO_CONTROLADO]') 
					AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_CPL_MOVIMENTACAO_CONTROLADO]
GO
 

/****** Object:  StoredProcedure [dbo].[P_EST_PROD_CPL_MOVIMENTACAO_CONTROLADO]    Script Date: 03/07/2015 10:50:31 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*
EXEC P_EST_PROD_CPL_MOVIMENTACAO_CONTROLADO 1,999,'20100601','20100630'
SELECT * FROM EST_PROD_CPL_MOVIMENTACAO_CONTROLADO_CPL
*/
CREATE PROCEDURE [dbo].[P_EST_PROD_CPL_MOVIMENTACAO_CONTROLADO] 	(@CD_EMP	INT,
																		@CD_FILIAL	INT,
																		@DT_INI		DATETIME,
																		@DT_FIM		DATETIME,
																		@CD_CTR_ANT     INT)
AS
BEGIN


DECLARE @DT_FECHA DATETIME
DECLARE @DT_POS_INI DATETIME
DECLARE @DT_POS_FIM DATETIME

SET @DT_FECHA = DBO.F_INICIO_MES(@DT_INI)
SET @DT_FECHA = @DT_FECHA -1

 
UPDATE
	EST_PROD_CPL_MOVIMENTACAO_CONTROLADO
SET
	MOVI_FECHADO=1
WHERE
	CD_EMP =@CD_EMP 
	AND CD_FILIAL = @CD_FILIAL
	AND DT_FINAL<@DT_INI

CREATE TABLE #RsProdFechaMes (CD_EMP INT,
							  CD_FILIAL INT,
							  CD_PROD INT,
							  QT_EST_FECHA MONEY)

CREATE TABLE #RsProd(CD_EMP INT,
					 CD_FILIAL INT,
					 RZ_FILIAL VARCHAR(150),
					 DS_CID  VARCHAR (100),
					 UF VARCHAR(10),
					 CD_PROD INT,
					 DS_PROD VARCHAR(200),
					 NM_FABRIC VARCHAR(100),
					 CD_DCB  VARCHAR(50),	
					 DS_PRINC_ATIVOS VARCHAR(250),
				     QT_EST MONEY,
					 QT_EST_INI MONEY,
					 CD_PRINC_ATIVOS INT,
	                 CD_RECEITA_TIPO INT)

CREATE TABLE #RsProdMov(CONTROLE INT IDENTITY (1, 1),
						CD_EMP INT,
						RZ_FILIAL VARCHAR(150),
						DS_CID  VARCHAR (100),
						UF VARCHAR(10),
						CD_PROD INT,	
						DS_PROD VARCHAR(200),
						NM_FABRIC VARCHAR(100),
						CD_DCB VARCHAR(50),
						DS_PRINC_ATIVOS VARCHAR(250),
						QT_EST MONEY,
						QT_EST_FINAL MONEY,
						QT_EST_INI MONEY,
						DT_MOV DATETIME,
						NR_NF INT,
						CGC_CPF VARCHAR(30),
						NM_ORIG VARCHAR(200),
						NR_LOTE VARCHAR(60),
						QT_ENT MONEY,
						QT_SAI MONEY,
						QT_EST_SALDO  MONEY,
						TP_TRANSA INT,
						EST_DIF INT,
						CD_PRINC_ATIVOS INT,
						CD_RECEITA_TIPO INT)
	-- TEVE RELATORIO GERADO MES ANTERIOER	
											
IF @CD_CTR_ANT=0
begin
	INSERT INTO #RsProdFechaMes
	SELECT
		EST_FECHA.CD_EMP,
		EST_FECHA.CD_FILIAL,
		EST_FECHA.CD_PROD,
		EST_FECHA.QT_EST
	FROM
		EST_FECHA INNER JOIN EST_PROD ON
		EST_FECHA.CD_EMP = EST_PROD.CD_EMP AND
		EST_FECHA.CD_PROD = EST_PROD.CD_PROD 
	WHERE
		EST_FECHA.CD_EMP = @CD_EMP 
		AND EST_FECHA.CD_FILIAL = @CD_FILIAL
		AND EST_FECHA.ANO_FECHA = YEAR(@DT_FECHA)
		AND EST_FECHA.MES_FECHA = MONTH(@DT_FECHA)
		AND EST_PROD.FLAG_PRODUTO_CONTROLADO = 1	
						
end
						
INSERT INTO #RsProd
SELECT
	EST_PROD_CPL.CD_EMP, 
	EST_PROD_CPL.CD_FILIAL, 
	PRC_FILIAL.RZ_FILIAL, 
	GLB_CID.DS_CID, 
	GLB_CID.UF,
	EST_PROD_CPL.CD_PROD, 
	EST_PROD.DS_PROD, 
	EST_PROD_FABRIC.NM_FABRIC, 
    EST_PROD_PRINC_ATIVOS.CD_DCB, 
	ISNULL(EST_PROD_PRINC_ATIVOS.DS_PRINC_ATIVOS,'NO DEFINIDO'), 
	EST_PROD_CPL.QT_EST,
	CASE WHEN @CD_CTR_ANT > 0 THEN isnull(rsAnt.QT_EST_FINAL,0) ELSE isnull(f.QT_EST_FECHA,0) END QT_EST_FINAL,
    ISNULL(EST_PROD_PRINC_ATIVOS.CD_PRINC_ATIVOS,0) AS CD_PRINC_ATIVOS,
	ISNULL(EST_PROD_PRINC_ATIVOS.CD_RECEITA_TIPO,0) AS CD_RECEITA_TIPO
FROM         
	EST_PROD INNER JOIN EST_PROD_CPL ON 
	EST_PROD.CD_EMP = EST_PROD_CPL.CD_EMP AND 
	EST_PROD.CD_PROD = EST_PROD_CPL.CD_PROD 
	INNER JOIN EST_PROD_FABRIC ON 
	EST_PROD.CD_FABRIC = EST_PROD_FABRIC.CD_FABRIC 
	LEFT OUTER JOIN EST_PROD_PRINC_ATIVOS_EST_PROD ON 
	EST_PROD.CD_EMP = EST_PROD_PRINC_ATIVOS_EST_PROD.CD_EMP AND 
    EST_PROD.CD_PROD = EST_PROD_PRINC_ATIVOS_EST_PROD.CD_PROD 
	LEFT OUTER JOIN EST_PROD_PRINC_ATIVOS ON 
	EST_PROD_PRINC_ATIVOS_EST_PROD.CD_PRINC_ATIVOS = EST_PROD_PRINC_ATIVOS.CD_PRINC_ATIVOS
	INNER JOIN PRC_FILIAL ON
	EST_PROD_CPL.CD_EMP = PRC_FILIAL.CD_EMP AND
	EST_PROD_CPL.CD_FILIAL = PRC_FILIAL.CD_FILIAL 
	INNER JOIN GLB_CID ON 
	PRC_FILIAL.CD_CID = GLB_CID.CD_CID
	LEFT OUTER JOIN 
		(SELECT
				DISTINCT 
				1 AS CD_EMP,
				CD_PROD,
				QT_EST_FINAL 
			FROM
				EST_PROD_CPL_MOVIMENTACAO_CONTROLADO_CPL C
			WHERE
				CD_CTR = @CD_CTR_ANT
				AND CONTROLE = (SELECT MAX(CONTROLE)  FROM EST_PROD_CPL_MOVIMENTACAO_CONTROLADO_CPL L WHERE CD_CTR = @CD_CTR_ANT AND C.CD_PROD = L.CD_PROD) )
				rsAnt ON
	EST_PROD.CD_EMP = rsAnt.CD_EMP AND
	EST_PROD.CD_PROD = rsAnt.CD_PROD
	LEFT OUTER JOIN #RsProdFechaMes f ON
	EST_PROD_CPL.CD_EMP = f.CD_EMP AND
	EST_PROD_CPL.CD_FILIAL = f.CD_FILIAL AND
	EST_PROD_CPL.CD_PROD = f.CD_PROD 
WHERE     
	EST_PROD_CPL.CD_EMP = @CD_EMP 
	AND EST_PROD_CPL.CD_FILIAL = @CD_FILIAL
	AND EST_PROD.FLAG_PRODUTO_CONTROLADO = 1
	
INSERT INTO #RsProdMov
SELECT     
	p.CD_EMP,
	p.RZ_FILIAL,
	p.DS_CID,
	p.UF,
	p.CD_PROD,
	p.DS_PROD,
	p.NM_FABRIC,
	p.CD_DCB,
	p.DS_PRINC_ATIVOS,
	p.QT_EST,
	0,
	p.QT_EST_INI,
	V_EST_NF_ENT.DT_ENT, 
	V_EST_NF_ENT.NR_NF, 
	V_EST_NF_ENT.CGC_CPF, 
	V_EST_NF_ENT.NM_ORIG, 
	ISNULL(EST_PROD_CPL_LOTE.NR_LOTE,''), 
    Isnull(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT) AS QT_PROD_ENT,
	0 AS QT_PROD_SAI,
	0,
	0 AS TP_TRANSA,
	0,
	p.CD_PRINC_ATIVOS,
	p.CD_RECEITA_TIPO
FROM         
	V_EST_NF_ENT LEFT OUTER JOIN EST_NF_ENT_IT_EST_PROD_CPL_LOTE ON 
	V_EST_NF_ENT.CD_EMP = EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP AND 
    V_EST_NF_ENT.CD_FILIAL = EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL AND 
	V_EST_NF_ENT.CD_NF = EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_NF AND 
    V_EST_NF_ENT.CD_PROD = EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_PROD
	LEFT OUTER JOIN EST_PROD_CPL_LOTE ON 
	EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_PROD_CPL_LOTE.CD_EMP AND 
    EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_PROD_CPL_LOTE.CD_FILIAL AND 
    EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_LOTE = EST_PROD_CPL_LOTE.CD_LOTE	
	INNER JOIN #RSPROD p ON
	V_EST_NF_ENT.CD_EMP = p.CD_EMP AND
	V_EST_NF_ENT.CD_FILIAL = p.CD_FILIAL AND
	V_EST_NF_ENT.CD_PROD = p.CD_PROD 
WHERE
     V_EST_NF_ENT.CD_EMP = @CD_EMP AND
     V_EST_NF_ENT.CD_FILIAL = @CD_FILIAL AND 
	V_EST_NF_ENT.DT_ENT BETWEEN @DT_INI AND @DT_FIM
	AND V_EST_NF_ENT.ATU_EST = 1
	AND V_EST_NF_ENT.TP_ESTQ = 0
UNION ALL
SELECT     
	p.CD_EMP,
	p.RZ_FILIAL, 
	p.DS_CID,
	p.UF,
	p.CD_PROD,
	p.DS_PROD,
	p.NM_FABRIC,
	p.CD_DCB,
	p.DS_PRINC_ATIVOS,
	p.QT_EST,
	0,
	p.QT_EST_INI,
	V_EST_NF_SAI.DT_EMI_NF, 
	V_EST_NF_SAI.NF_NF, 
	V_EST_NF_SAI.CGC_CPF, 
	V_EST_NF_SAI.NM_DEST, 
	ISNULL(EST_PROD_CPL_LOTE.NR_LOTE,''), 
    0,
	ISNULL(EST_NF_SAI_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_SAI.QT_IT),
	0,
	1 AS TP_TRANSA,
	0,
	p.CD_PRINC_ATIVOS,
	p.CD_RECEITA_TIPO
FROM        
	V_EST_NF_SAI LEFT OUTER JOIN EST_NF_SAI_IT_EST_PROD_CPL_LOTE ON 
	V_EST_NF_SAI.CD_EMP = EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_EMP AND 
    V_EST_NF_SAI.CD_FILIAL = EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_FILIAL AND 
	V_EST_NF_SAI.CD_NF = EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_NF AND 
    V_EST_NF_SAI.CD_PROD = EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_PROD AND
	V_EST_NF_SAI.CD_IT = EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_IT
	LEFT OUTER JOIN EST_PROD_CPL_LOTE ON 
	EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_EMP = EST_PROD_CPL_LOTE.CD_EMP AND 
    EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_FILIAL = EST_PROD_CPL_LOTE.CD_FILIAL AND 
	EST_NF_SAI_IT_EST_PROD_CPL_LOTE.CD_LOTE = EST_PROD_CPL_LOTE.CD_LOTE
	INNER JOIN #RSPROD p ON
	V_EST_NF_SAI.CD_EMP = p.CD_EMP AND
	V_EST_NF_SAI.CD_FILIAL = p.CD_FILIAL AND
	V_EST_NF_SAI.CD_PROD = p.CD_PROD 
WHERE
     V_EST_NF_SAI.CD_EMP = @CD_EMP AND
     V_EST_NF_SAI.CD_FILIAL = @CD_FILIAL AND 	
	V_EST_NF_SAI.DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM
	AND V_EST_NF_SAI.STS_NF = 0 
	AND V_EST_NF_SAI.BX_EST = 1
	AND V_EST_NF_SAI.TP_ESTQ = 0
	AND V_EST_NF_SAI.FLAG_IGNORAR_CONTROL = 0 
UNION ALL
SELECT     
	p.CD_EMP,
	p.RZ_FILIAL,
	p.DS_CID,
	p.UF,
	p.CD_PROD,
	p.DS_PROD,
	p.NM_FABRIC,
	p.CD_DCB,
	p.DS_PRINC_ATIVOS,
	p.QT_EST,
	0,
	p.QT_EST_INI,
	EST_PROD_IMP.DT_CAD, 
	EST_PROD_IMP.CD_IMP, 
	'' AS CGC_CPF, 
	'MOVIMENTACAO DE ESTOQUE' AS NM_ORIG, 
	'' AS NR_LOTE, 
	CASE WHEN EST_PROD_IMP.QT_IMP > 0 THEN
		EST_PROD_IMP.QT_IMP
	ELSE
		0	
	END,
	CASE WHEN EST_PROD_IMP.QT_IMP < 0 THEN
		EST_PROD_IMP.QT_IMP * -1
	ELSE
		0
	END,
	0,
	CASE WHEN EST_PROD_IMP.QT_IMP > 0 THEN
		0
	ELSE
		1	
	END,
	0,
	p.CD_PRINC_ATIVOS,
	p.CD_RECEITA_TIPO
FROM         
	EST_PROD_IMP INNER JOIN #RSPROD p ON
	EST_PROD_IMP.CD_EMP = p.CD_EMP AND
	EST_PROD_IMP.CD_FILIAL = p.CD_FILIAL AND
	EST_PROD_IMP.CD_PROD = p.CD_PROD 
WHERE
	EST_PROD_IMP.DT_CAD BETWEEN @DT_INI AND @DT_FIM
	AND EST_PROD_IMP.TP_IMP = 0 
	AND EST_PROD_IMP.TP_EST = 0
ORDER BY
	CD_PROD, 
	DT_ENT,
	TP_TRANSA, 
	NR_NF

INSERT INTO #RsProdMov
SELECT
	p.CD_EMP,
	p.RZ_FILIAL,
	p.DS_CID,
	p.UF,
	p.CD_PROD,
	p.DS_PROD,
	p.NM_FABRIC,
	p.CD_DCB,
	p.DS_PRINC_ATIVOS,
	p.QT_EST,
	0,
	p.QT_EST_INI,
	NULL AS DT_EMI_NF, 
	NULL AS NF_NF, 
	'' AS CGC_CPF, 
	'' AS NM_DEST, 
	'' , 
    0,
	0,
	0,
	0 AS TP_TRANSA,
	0,
	p.CD_PRINC_ATIVOS,
	p.CD_RECEITA_TIPO
FROM
	#RSPROD p
WHERE
	NOT EXISTS(SELECT 
					CD_PROD
				FROM
					#RsProdMov m
				WHERE	
					p.CD_EMP  = m.CD_EMP AND
					p.CD_PROD = m.CD_PROD)		

DECLARE @CONTROLE INT
DECLARE @CD_PROD INT
DECLARE @QT_EST MONEY
DECLARE @QT_EST_INI MONEY
DECLARE @QT_EST_MOV MONEY
DECLARE @QT_ENT MONEY
DECLARE @QT_SAI MONEY
DECLARE @CD_CTR INT

DECLARE @CONTROLE_ANT INT
DECLARE @CD_PROD_ANT INT
DECLARE @QT_EST_ANT MONEY
DECLARE @NR_LOTE VARCHAR(50)
DECLARE @NR_LOTE_ANT VARCHAR(50)

SET @CD_PROD_ANT=0
SET @CONTROLE_ANT = 0
SET @QT_EST_ANT = 0
SET @QT_EST_MOV = 0
SET @NR_LOTE = ''
SET @NR_LOTE_ANT = ''
SET @CD_CTR = 0

DECLARE ProcMov CURSOR FAST_FORWARD FOR SELECT CONTROLE,CD_PROD,QT_EST_FINAL,QT_EST_INI,QT_ENT,QT_SAI,NR_LOTE FROM #RsProdMov order by CONTROLE
OPEN ProcMov
FETCH NEXT FROM PROCMOV INTO @CONTROLE,@CD_PROD,@QT_EST,@QT_EST_INI,@QT_ENT,@QT_SAI,@NR_LOTE
WHILE @@FETCH_STATUS=0
  BEGIN
	PRINT	'ANALISANDO PRODUTO: ' + CONVERT(VARCHAR(50), @CD_PROD) + ', CODIGO CONTROLE ' + CONVERT(VARCHAR(50), @CONTROLE)
	PRINT	'@CD_PROD          : ' + CONVERT(VARCHAR(50), @CD_PROD)
	PRINT	'@CD_PROD_ANT      : ' + CONVERT(VARCHAR(50), @CD_PROD_ANT)
	PRINT	'@CONTROLE_ANT     : ' + CONVERT(VARCHAR(50), @CONTROLE_ANT)
	PRINT	'@CONTROLE         : ' + CONVERT(VARCHAR(50), @CONTROLE)
	
	IF @CD_PROD <> @CD_PROD_ANT
		BEGIN
			SET @NR_LOTE_ANT = ''			
			IF @QT_EST_MOV <> @QT_EST_ANT AND @CONTROLE_ANT > 0
				BEGIN  
					UPDATE #RSPRODMOV SET EST_DIF = 1 WHERE CONTROLE = @CONTROLE_ANT
				END

			IF  @CONTROLE_ANT > 0 BEGIN 
				PRINT  'ALTEROU O ESTOQUE FINAL DO PRODUTO: ' + CONVERT(VARCHAR(50), @CD_PROD_ANT) 
				PRINT	'@CONTROLE_ANT     : ' + CONVERT(VARCHAR(50), @CONTROLE_ANT)
				PRINT	'@CONTROLE         : ' + CONVERT(VARCHAR(50), @CONTROLE)
										
			END

			--PRINT	'NOVO PRODUTO ' + CONVERT(VARCHAR(10), @CD_PROD)
			SET @CD_PROD_ANT = @CD_PROD
			SET @QT_EST_MOV = @QT_EST_INI
			SET @QT_EST_ANT = @QT_EST		
		END	
		
	IF 
		LTRIM(RTRIM(@NR_LOTE)) <> ''	BEGIN SET @NR_LOTE_ANT = @NR_LOTE
	END
		
		--PRINT	'LOTE ATUAL ' + CONVERT(VARCHAR(10), @NR_LOTE)
		--PRINT	'LOTE ANTERIOR ' + CONVERT(VARCHAR(10), @NR_LOTE_ANT)

	IF 
		LTRIM(RTRIM(@NR_LOTE)) = ''  BEGIN SET @NR_LOTE = @NR_LOTE_ANT
	END

	SET @CONTROLE_ANT = @CONTROLE
	SET @CD_PROD_ANT = @CD_PROD
		
	--PRINT	'ESTOQUE ANTERIOR ' + CONVERT(VARCHAR(10), ((@QT_EST_MOV + @QT_ENT) - @QT_SAI))
	
	-- Atualizando o Saldo
	UPDATE 	#RSPRODMOV SET @QT_EST_MOV = (@QT_EST_MOV + @QT_ENT) - @QT_SAI, 
						   QT_EST_SALDO = @QT_EST_MOV, 
						   NR_LOTE = @NR_LOTE, 	
						   QT_EST_FINAL = @QT_EST_MOV
	WHERE CONTROLE = @CONTROLE
	
	PRINT	'ESTOQUE NOVO ' + CONVERT(VARCHAR(50), @QT_EST_MOV)

	FETCH NEXT FROM PROCMOV INTO @CONTROLE,@CD_PROD,@QT_EST,@QT_EST_INI,@QT_ENT,@QT_SAI,@NR_LOTE
  end
--PRINT 'Concludo.'
CLOSE ProcMov
DEALLOCATE ProcMov

	SET @CD_CTR = ISNULL((SELECT MAX(CD_CTR) FROM EST_PROD_CPL_MOVIMENTACAO_CONTROLADO),0)
	SET @CD_CTR = @CD_CTR + 1

	INSERT INTO EST_PROD_CPL_MOVIMENTACAO_CONTROLADO (CD_CTR,CD_EMP,CD_FILIAL,DT_INI,DT_FINAL,CD_CTR_ANT,MOVI_FECHADO)
	SELECT
		@CD_CTR, 
		@CD_EMP,
		@CD_FILIAL,
		@DT_INI,
		@DT_FIM,
		@CD_CTR_ANT,
		0

	INSERT INTO  EST_PROD_CPL_MOVIMENTACAO_CONTROLADO_CPL 
	(
		CD_CTR, 
		CONTROLE, 
		CD_EMP, 
		RZ_FILIAL, 
		DS_CID, 
		UF, 
		CD_PROD, 
		DS_PROD, 
		NM_FABRIC, 
		CD_DCB, 
		DS_PRINC_ATIVOS, 
		QT_EST, 
		QT_EST_FINAL, 
		QT_EST_INI, 
		DT_MOV, 
		NR_NF, 
		CGC_CPF, 
		NM_ORIG, 
		NR_LOTE, 
		QT_ENT, 
		QT_SAI, 
		QT_EST_SALDO, 
		TP_TRANSA, 
		EST_DIF,
		CD_PRINC_ATIVOS,
		CD_RECEITA_TIPO)
	SELECT 
		@CD_CTR,
		CONTROLE,
		CD_EMP,
		RZ_FILIAL, 
		DS_CID, 
		UF,
		CD_PROD,
		DS_PROD,
		NM_FABRIC,
		CD_DCB,
		DS_PRINC_ATIVOS,
		QT_EST,
		QT_EST_FINAL,
		QT_EST_INI,
		DT_MOV,NR_NF,
		CGC_CPF,
		NM_ORIG,
		NR_LOTE,
		QT_ENT,
		QT_SAI,
		QT_EST_SALDO,
		TP_TRANSA,
		EST_DIF,
		CD_PRINC_ATIVOS,
		CD_RECEITA_TIPO
	FROM 
		#RSPRODMOV 

	--select * from #RSPRODMOV 

	--DROP TABLE #RsProdFechaMes
	--DROP TABLE #RsProd
	--DROP TABLE #RsProdMov

RETURN
End 